/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.io.FileReader;
import java.io.Serializable;
import weka.classifiers.bayes.net.VaryNode;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class ADNode
implements Serializable,
TechnicalInformationHandler,
RevisionHandler {
    static final long serialVersionUID = 397409728366910204L;
    static final int MIN_RECORD_SIZE = 0;
    public VaryNode[] m_VaryNodes;
    public Instance[] m_Instances;
    public int m_nCount;
    public int m_nStartNode;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Andrew W. Moore and Mary S. Lee");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Cached Sufficient Statistics for Efficient Machine Learning with Large Datasets");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Journal of Artificial Intelligence Research");
        result.setValue(TechnicalInformation.Field.VOLUME, "8");
        result.setValue(TechnicalInformation.Field.PAGES, "67-91");
        return result;
    }

    public static VaryNode makeVaryNode(int iNode, FastVector nRecords, Instances instances) {
        VaryNode _VaryNode = new VaryNode(iNode);
        int nValues = instances.attribute(iNode).numValues();
        FastVector[] nChildRecords = new FastVector[nValues];
        int iChild = 0;
        while (iChild < nValues) {
            nChildRecords[iChild] = new FastVector();
            ++iChild;
        }
        int iRecord = 0;
        while (iRecord < nRecords.size()) {
            int iInstance = (Integer)nRecords.elementAt(iRecord);
            nChildRecords[(int)instances.instance(iInstance).value(iNode)].addElement(new Integer(iInstance));
            ++iRecord;
        }
        int nCount = nChildRecords[0].size();
        int nMCV = 0;
        int iChild2 = 1;
        while (iChild2 < nValues) {
            if (nChildRecords[iChild2].size() > nCount) {
                nCount = nChildRecords[iChild2].size();
                nMCV = iChild2;
            }
            ++iChild2;
        }
        _VaryNode.m_nMCV = nMCV;
        _VaryNode.m_ADNodes = new ADNode[nValues];
        iChild2 = 0;
        while (iChild2 < nValues) {
            _VaryNode.m_ADNodes[iChild2] = iChild2 == nMCV || nChildRecords[iChild2].size() == 0 ? null : ADNode.makeADTree(iNode + 1, nChildRecords[iChild2], instances);
            ++iChild2;
        }
        return _VaryNode;
    }

    public static ADNode makeADTree(int iNode, FastVector nRecords, Instances instances) {
        ADNode _ADNode = new ADNode();
        _ADNode.m_nCount = nRecords.size();
        _ADNode.m_nStartNode = iNode;
        if (nRecords.size() < 0) {
            _ADNode.m_Instances = new Instance[nRecords.size()];
            int iInstance = 0;
            while (iInstance < nRecords.size()) {
                _ADNode.m_Instances[iInstance] = instances.instance((Integer)nRecords.elementAt(iInstance));
                ++iInstance;
            }
        } else {
            _ADNode.m_VaryNodes = new VaryNode[instances.numAttributes() - iNode];
            int iNode2 = iNode;
            while (iNode2 < instances.numAttributes()) {
                _ADNode.m_VaryNodes[iNode2 - iNode] = ADNode.makeVaryNode(iNode2, nRecords, instances);
                ++iNode2;
            }
        }
        return _ADNode;
    }

    public static ADNode makeADTree(Instances instances) {
        FastVector<Integer> nRecords = new FastVector<Integer>(instances.numInstances());
        int iRecord = 0;
        while (iRecord < instances.numInstances()) {
            nRecords.addElement(new Integer(iRecord));
            ++iRecord;
        }
        return ADNode.makeADTree(0, nRecords, instances);
    }

    public void getCounts(int[] nCounts, int[] nNodes, int[] nOffsets, int iNode, int iOffset, boolean bSubstract) {
        if (iNode >= nNodes.length) {
            if (bSubstract) {
                int n = iOffset;
                nCounts[n] = nCounts[n] - this.m_nCount;
            } else {
                int n = iOffset;
                nCounts[n] = nCounts[n] + this.m_nCount;
            }
            return;
        }
        if (this.m_VaryNodes != null) {
            this.m_VaryNodes[nNodes[iNode] - this.m_nStartNode].getCounts(nCounts, nNodes, nOffsets, iNode, iOffset, this, bSubstract);
        } else {
            int iInstance = 0;
            while (iInstance < this.m_Instances.length) {
                int iOffset2 = iOffset;
                Instance instance = this.m_Instances[iInstance];
                int iNode2 = iNode;
                while (iNode2 < nNodes.length) {
                    iOffset2 += nOffsets[iNode2] * (int)instance.value(nNodes[iNode2]);
                    ++iNode2;
                }
                if (bSubstract) {
                    int n = iOffset2;
                    nCounts[n] = nCounts[n] - 1;
                } else {
                    int n = iOffset2;
                    nCounts[n] = nCounts[n] + 1;
                }
                ++iInstance;
            }
        }
    }

    public void print() {
        String sTab = new String();
        int i = 0;
        while (i < this.m_nStartNode) {
            sTab = String.valueOf(sTab) + "  ";
            ++i;
        }
        System.out.println(String.valueOf(sTab) + "Count = " + this.m_nCount);
        if (this.m_VaryNodes != null) {
            int iNode = 0;
            while (iNode < this.m_VaryNodes.length) {
                System.out.println(String.valueOf(sTab) + "Node " + (iNode + this.m_nStartNode));
                this.m_VaryNodes[iNode].print(sTab);
                ++iNode;
            }
        } else {
            System.out.println(this.m_Instances);
        }
    }

    public static void main(String[] argv) {
        try {
            Instances instances = new Instances(new FileReader("\\iris.2.arff"));
            ADNode ADTree = ADNode.makeADTree(instances);
            int[] nCounts = new int[12];
            int[] nNodes = new int[3];
            int[] nOffsets = new int[3];
            nNodes[0] = 0;
            nNodes[1] = 3;
            nNodes[2] = 4;
            nOffsets[0] = 2;
            nOffsets[1] = 1;
            nOffsets[2] = 4;
            ADTree.print();
            ADTree.getCounts(nCounts, nNodes, nOffsets, 0, 0, false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

